package main

import (
	"context"
	"log"
	"os"

	"github.com/gntous/unityredisctl/internal/commands"
	"github.com/urfave/cli/v3"
)

func main() {
	cmd := &cli.Command{
		Name:        "unityredisctl",
		Usage:       "A tool to manage Unity Redis",
		Description: "A tool to manage Unity Redis",
		Commands: []*cli.Command{
			&commands.ExportCommand,
			&commands.ImportCommand,
			&commands.DiffCommand,
		},
	}

	if err := cmd.Run(context.Background(), os.Args); err != nil {
		log.Fatal(err)
	}
}
